﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.MDWS;
using System.Text;
using System.Runtime.InteropServices;
using Telerik.Web.UI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_InstrumentCarePlanEntry : BaseTBIInstrumentPage
{
    #region Variable Declarations

    private const string FailedFormValuesName = "IRCRFailedFormValues";
    private const string DeferredMessageKeyName = "IRCRDeferredMessageKey";
    private const string LabelIDFormat = "LabelQ{0}ChoiceID";
    private const string CheckBoxIDFormat = "CheckBoxQ{0}";
    private const string TextBoxIDFormat = "TextBoxQ{0}Detail";

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    int _surveyTypeId = 5; // Database Id for CAREPLAN 

    SURVEY _survey;   // the root object in the Survey set
    #endregion

    #region Public Methods

    public TBI_InstrumentCarePlanEntry()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion Public Methods

    #region Protected Methods

    protected void Page_Init(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    bool preventNotification = false;
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
        {
            RestoreRepeaterFromCache(RepeaterQ4, "4", cache);
            RestoreRepeaterFromCache(RepeaterQ6, "6", cache);
            RestoreRepeaterFromCache(RepeaterQ10, "10", cache);
            SuppressSaveMessage = false;
            SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
            RenderStartUpMessage(false);
        }
        else if (Page.IsPostBack && !preventNotification)
        {
            DeferredMessage = "Save was Successful!";
        }
        else if (DeferredMessage != null)
        {
            SuppressSaveMessage = false;
            SaveSuccessMessage = DeferredMessage;
            RenderStartUpMessage(true);
            DeferredMessage = null;
        }
    }

    private void RestoreRepeaterFromCache(Repeater repeater, string questionNumber, Dictionary<string, string> cache)
    {
        string checkBoxID = string.Format(CheckBoxIDFormat, questionNumber);
        string textBoxID = string.Format(TextBoxIDFormat, questionNumber);
        for (int i = 0; i < repeater.Items.Count; i++)
        {
            var checkBoxItem = repeater.Items[i].FindControl(checkBoxID) as CheckBox;
            var textBoxItem = repeater.Items[i].FindControl(textBoxID) as TextBox;
            if (checkBoxItem != null && textBoxItem != null)
            {
                var s = cache[string.Format("{0}{1}{2}", questionNumber, (char)1, i)];
                var values = s.Split((char)1);
                checkBoxItem.Checked = bool.Parse(values[0]);
                textBoxItem.Text = values[1];
            }
        }
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }

    /// <summary>
    /// In addition to the normal actions taken in Page_Load,
    /// instantiate the MDWS Web Service (T)ransfer (O)bject.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            SetQuestionLabels();
            CompareValidatorQ11_1.ValueToCompare = DateTime.Now.ToString("MM/dd/yyyy");

            if (_tbiInstrumentManager != null)
            {
                LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;
            }

            _tbiInstrumentManager.TbiServiceTo = base.GetTBIServiceTo();
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("InstrumentCarePlanEntry.Page_Load(): WarningRedirect: Commented out: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (!IsPostBack)
            {
                string _snum = string.Empty;

                base.AddtoViewStateTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                if (instrumentType.Status != null)
                {
                    _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
                }

                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);

                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                if (labelUser != null)
                {
                    labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
                }

                if (!string.IsNullOrEmpty(_snum))
                {
                    string patICN = patientManager.GetPatientICNBySnum(_snum);

                    if (!string.IsNullOrEmpty(patICN))
                    {
                        ViewState["PatientICN"] = patICN;
                        RefreshSurvey(patICN);
                    }
                    else
                    {
                        throw new ArgumentException("Patient with this SSN does not exist.");
                    }

                    string referrer = string.Empty;
                    if (Request.UrlReferrer != null)
                    {
                        referrer = Request.UrlReferrer.PathAndQuery;
                    }
                    ViewState["referrer"] = referrer;
                }
            }
        }
        catch (Exception ex2)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex2, "InstrumentCarePlanEntry.aspx", "100030", "Page_Load()");
            Response.Redirect("Warning.aspx?err=2");
        }
    }

    protected override void OnPreRenderComplete(EventArgs e)
    {
        try
        {
            bool isInitialNote = false;
            if (_tbiInstrumentManager.TbiServiceTo != null)
            {
                isInitialNote = _tbiInstrumentManager.IsInitialNoteType(_tbiInstrumentManager.TbiServiceTo.PatientICN, _surveyTypeId);
            }

            if (!IsPostBack)
            {
                if (_survey != null)
                {
                    if (!_survey.isNew)
                    {
                        SetUpSurvey(_survey);
                    }
                    else
                    {
                        if (!isInitialNote)
                        {
                            CarryForwardData(_tbiInstrumentManager.TbiServiceTo.PatientICN);
                        }
                    }
                }
            }

            if (_survey != null)
            {
                //Handle note type
                if (isInitialNote)
                {
                    if (RadioButtonListNoteType.SelectedIndex == -1)
                    {
                        RadioButtonListNoteType.SelectedIndex = 0;
                    }

                    hiddenNoteType.Value = "0"; //Used by client side validation
                    CustomValidatorNoteType.ErrorMessage = "Please select 'Initial' option to correct Note Type.";
                }
                else
                {
                    hiddenNoteType.Value = ""; //Used by client side validation
                    CustomValidatorNoteType.ErrorMessage = "Please select an option other than 'Initial' to correct Note Type.";
                }
            }

            //Provide Client IDs of repeater controls to custom validators 
            embedClientIDs(ref RepeaterQ4, ref Q4Label);
            embedClientIDs(ref RepeaterQ6, ref Q6Label);
            embedClientIDs(ref RepeaterQ10, ref Q10Label);
        }
        finally
        {
            base.OnPreRenderComplete(e);
        }
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }


    protected void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        //if (Page.IsValid)
        //{
        //    Int32 status = 0;
        //    SaveFailMessage = "Save Successful";
        //    SaveCompleteSurvey(ref status);
        //    SetUpSurvey(_survey);
        //}
        Int32 status = 0;
        SaveFailMessage = "Save Succeeded";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        try
        {
            if (Page.IsValid)
            {
                Int32 status = 0;
                SaveFailMessage = "Save Successful";
                SaveCompleteSurvey(ref status);
                if (status > 0)
                {
                    preventNotification = true;
                    Session["survey"] = _survey;
                    Response.Redirect("InstrumentSummaryNote.aspx", false);
                }
                else
                {
                    Response.Redirect(Request.Url.PathAndQuery, false); 
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "btnSubmit_Click()");
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        preventNotification = true;
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    #endregion

    #region Private Methods

    private void embedClientIDs(ref Repeater rep, ref Label lbl)
    {
        string questionNumber = rep.ID.LastChars(rep.ID.Length - "RepeaterQ".Length);

        string checkBoxName = "CheckBoxQ" + questionNumber;
        string textBoxName = "TextBoxQ" + questionNumber + "Detail";
        string customValidatorDetailName = "CustomValidatorRepeaterQ" + questionNumber + "_Detail";

        for (int i = 0; i < rep.Items.Count; i++)
        {
            CheckBox checkBoxItem = rep.Items[i].FindControl(checkBoxName) as CheckBox;
            TextBox textBoxItem = rep.Items[i].FindControl(textBoxName) as TextBox;
            CustomValidator cValidator_Detail = rep.Items[i].FindControl(customValidatorDetailName) as CustomValidator;

            if (checkBoxItem != null && textBoxItem != null && cValidator_Detail != null)
            {
                try
                {
                    //Save client names of constituent controls in the item template of the repeater as custom attributes of corresponding custom validator
                    ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "chkId", checkBoxItem.ClientID);
                    ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "txtId", textBoxItem.ClientID);

                    //Mark Other item in the repeater 
                    if (checkBoxItem.Text == "Other")
                    {
                        ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "flagOther", "true");
                    }
                    else
                    {
                        ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "flagOther", "false");
                    }

                    //Save the name of first checkbox in the repeater 
                    if (i == 0)
                    {
                        ClientScript.RegisterExpandoAttribute(lbl.ClientID, "nameControlToValidate", checkBoxItem.ClientID);
                    }
                }
                catch (Exception ex)
                {
                    Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "embedClientIds()");
                }
            }
        }
    }

    private void Repeater_ItemDataBound(ref object sender, ref RepeaterItemEventArgs e, string questionNumber, string questionLabelName)
    {
        string checkBoxName = "CheckBoxQ" + questionNumber;
        string textBoxName = "TextBoxQ" + questionNumber + "Detail";
        string customValidatorDetailName = "CustomValidatorRepeaterQ" + questionNumber + "_Detail";

        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            CheckBox checkBoxItem = e.Item.FindControl(checkBoxName) as CheckBox;
            TextBox textBoxItem = e.Item.FindControl(textBoxName) as TextBox;
            CustomValidator cValidator_Detail = e.Item.FindControl(customValidatorDetailName) as CustomValidator;

            if (checkBoxItem != null && textBoxItem != null && cValidator_Detail != null)
            {
                try
                {
                    //Save client names of constituent controls in the item template of the repeater as custom attributes of corresponding custom validator
                    ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "chkId", checkBoxItem.ClientID);
                    ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "txtId", textBoxItem.ClientID);

                    //Mark Other item in the repeater 
                    if (checkBoxItem.Text == "Other")
                    {
                        ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "flagOther", "true");
                    }
                    else
                    {
                        ClientScript.RegisterExpandoAttribute(cValidator_Detail.ClientID, "flagOther", "false");
                    }

                    //Save the name of first checkbox in the repeater 
                    if (e.Item.ItemIndex == 0)
                    {
                        ClientScript.RegisterExpandoAttribute(questionLabelName, "nameControlToValidate", checkBoxItem.ClientID);
                    }
                }
                catch (Exception ex)
                {
                    Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "Repeater_ItemDataBound()");
                }
            }
        }
    }

    private void RefreshSurvey(string patientICN)
    {
        try
        {
            var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

            if (surveys.Count > 0)
            {
                _survey = surveys.First();
            }
            else
            {
                _survey = new SURVEY();
            }

            _survey.SetAsChangeTrackingRoot();
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "RefreshSurvey()");
        }
    }

    private void CarryForwardData(string patientICN)
    {
        try
        {
            //Compile list of questions for which responses should be carried over from the last completed survey
            List<string> questionList = new List<string>();
            questionList.Add("1");
            questionList.Add("2");
            questionList.Add("2-1");
            questionList.Add("4");
            questionList.Add("5");


            SURVEY lastSurvey = (_tbiInstrumentManager.SelectLastCompletedSurveyByPatientICNAndSurveyType(patientICN, _surveyTypeId)).First();

            if (lastSurvey != null)
            {
                SetUpSurvey(lastSurvey, questionList);
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "CarryForwardData()");
        }
    }

    private void SaveCompleteSurvey(ref Int32 status)
    {
        try
        {
            string patientICN = String.Empty;
            status = 0;
            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("InstrumentCarePlanEntry.SaveCompeletedSurvey(): WarningRedirect: patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("InstrumentCarePlanEntry.SaveCompeletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2", false);
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("InstrumentCarePlanEntry.SaveCompeletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";
                        _survey.SetAsInsertOnSubmit();
                        _survey.patient_ICN = patientICN;
                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;
                        _survey.SURVEY_DATE = DateTime.Today;
                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;
                        RefreshSurvey(patientICN);
                    }
                }
                SaveSurvey(ref _survey);
                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);
                if (status != 0)
                {
                    ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);
                    RefreshSurvey(patientICN);
                    SuppressSaveMessage = false;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "SaveCompleteSurvey()");
        }
        finally
        {
            if (status == 0)
            {
                var cache = Helpers.SavePageToCache(this, FailedFormValuesName);
                SaveRepeaterToCache(RepeaterQ4, "4", cache);
                SaveRepeaterToCache(RepeaterQ6, "6", cache);
                SaveRepeaterToCache(RepeaterQ10, "10", cache);
            }
            else
                Session[FailedFormValuesName] = null;//clear out the cached version on success
        }
    }

    private static void SaveRepeaterToCache(Repeater repeater, string questionNumber, Dictionary<string, string> cache)
    {
        string checkBoxID = string.Format(CheckBoxIDFormat, questionNumber);
        string textBoxID = string.Format(TextBoxIDFormat, questionNumber);
        for (int i = 0; i < repeater.Items.Count; i++)
        {
            var checkBoxItem = repeater.Items[i].FindControl(checkBoxID) as CheckBox;
            var textBoxItem = repeater.Items[i].FindControl(textBoxID) as TextBox;
            if (checkBoxItem != null && textBoxItem != null)
            {
                cache.Add(string.Format("{0}{1}{2}", questionNumber, (char)1, i), string.Format("{0}{1}{2}", checkBoxItem.Checked, (char)1, textBoxItem.Text));
            }
        }
    }

    private void SaveSingleSelect(SURVEY survey, RadioButtonList radioButtonList, string questionNumber, string otherText)
    {
        if (radioButtonList.SelectedIndex > -1)
        {
            List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
            SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
            int selectedValue = Convert.ToInt32(radioButtonList.SelectedValue);
            if (radioButtonList.Items[radioButtonList.SelectedIndex].Text.ToUpper() != "OTHER")
                otherText = null;
            if (null != currentResult)
            {
                if (currentResult.STD_QUESTION_CHOICE_ID != selectedValue || currentResult.RESULT_TEXT != otherText)
                {
                    currentResult.SetAsUpdateOnSubmit();
                    currentResult.STD_QUESTION_CHOICE_ID = selectedValue;
                    currentResult.RESULT_TEXT = otherText;
                }
                else
                {
                    currentResult.SetAsNoChangeOnSubmit();
                }
            }
            else
            {
                SURVEY_RESULT result = new SURVEY_RESULT();
                survey.SURVEY_RESULTs.Add(result);
                result.STD_QUESTION_CHOICE_ID = selectedValue;
                result.RESULT_TEXT = otherText;
            }
        }
    }

    private void SaveText(SURVEY survey, TextBox textBox, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        string inputText = textBox.Text;
        if (null != currentResult)
        {
            if (currentResult.RESULT_TEXT != inputText)
            {
                currentResult.SetAsUpdateOnSubmit();
                currentResult.RESULT_TEXT = inputText;
            }
            else
            {
                currentResult.SetAsNoChangeOnSubmit();
            }
        }
        else if (inputText != string.Empty)
        {
            SURVEY_RESULT result = new SURVEY_RESULT();
            result.RESULT_TEXT = inputText;
            result.STD_QUESTION_CHOICE_ID = availableChoices.FirstOrDefault(item => item.CHOICE_SORT_ORDER == 0).STD_QUESTION_CHOICE_ID;
            survey.SURVEY_RESULTs.Add(result);
        }

    }

    private void SaveMultiSelect(SURVEY survey, string questionNumber, CheckBoxList checkBoxList, string otherText)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        SURVEY_RESULT[] currentResults = survey.SURVEY_RESULTs.Where(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null).ToArray();
        foreach (ListItem item in checkBoxList.Items)
        {
            bool isOther = item.Text.ToUpper() == "OTHER";
            var selection = currentResults.Where(c => c.STD_QUESTION_CHOICE_ID == int.Parse(item.Value)).FirstOrDefault();
            if (item.Selected)
            {
                if (selection != null)
                {
                    //found it so it was here and no need to add it
                    if (isOther && selection.RESULT_TEXT != otherText)
                    {
                        selection.SetAsUpdateOnSubmit();
                        selection.RESULT_TEXT = otherText;
                    }
                    else
                    {
                        selection.SetAsNoChangeOnSubmit();
                    }
                }
                else
                {
                    //have not found it so need to add it.
                    SURVEY_RESULT result = new SURVEY_RESULT()
                    {
                        STD_QUESTION_CHOICE_ID = int.Parse(item.Value),
                        RESULT_TEXT = isOther ? otherText : null
                    };
                    survey.SURVEY_RESULTs.Add(result);
                }
            }
            //else it is already marked for deletion if it exists
        }
    }

    private void SaveRepeater(SURVEY survey, Repeater repeater, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        SURVEY_RESULT[] currentResults = survey.SURVEY_RESULTs.Where(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null).ToArray();
        string labelID = string.Format(LabelIDFormat, questionNumber);
        string checkBoxID = string.Format(CheckBoxIDFormat, questionNumber);
        string textBoxID = string.Format(TextBoxIDFormat, questionNumber);
        for (int i = 0; i < repeater.Items.Count; i++)
        {
            var labelItem = repeater.Items[i].FindControl(labelID) as Label;
            var checkBoxItem = repeater.Items[i].FindControl(checkBoxID) as CheckBox;
            var textBoxItem = repeater.Items[i].FindControl(textBoxID) as TextBox;
            if (labelItem != null && checkBoxItem != null && textBoxItem != null)
            {
                int itemChoiceID = Convert.ToInt32(labelItem.Text);
                var selection = currentResults.Where(c => c.STD_QUESTION_CHOICE_ID == itemChoiceID).FirstOrDefault();
                string inputText = textBoxItem.Text.Trim();
                if (checkBoxItem.Checked)
                {
                    if (null == selection)//not in the DB yet
                    {
                        var result = new SURVEY_RESULT();
                        result.STD_QUESTION_CHOICE_ID = itemChoiceID;
                        result.RESULT_TEXT = inputText;
                        survey.SURVEY_RESULTs.Add(result);
                    }
                    else if (selection.RESULT_TEXT != inputText)//in the db but with different text
                    {
                        selection.SetAsUpdateOnSubmit();
                        selection.RESULT_TEXT = inputText;
                    }
                    else//in the db and needs no change
                    {
                        selection.SetAsNoChangeOnSubmit();
                    }
                }
                //else, it is already marked for deletion
            }
            else
            {
                System.Diagnostics.Debug.WriteLine(string.Format("{0}:{1}:{2}:{3}:{4}", questionNumber, i, labelItem, checkBoxItem, textBoxItem));
            }
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        //first, mark all current answers for deletion
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();
        //now determine whether to add or update each item
        SaveSingleSelect(survey, RadioButtonListNoteType, "-1", null);
        SaveText(survey, TextBoxQ1, "1");
        SaveMultiSelect(survey, "2", CheckBoxListQ2, TextBoxQ2Detail.Text.Trim());
        SaveText(survey, TextBoxQ2Comment, "2-1");
        SaveMultiSelect(survey, "3", CheckBoxListQ3, TextBoxQ3Detail.Text.Trim());
        SaveText(survey, TextBoxQ3Comment, "3-1");
        SaveRepeater(survey, RepeaterQ4, "4");
        SaveText(survey, TextBoxQ5, "5");
        SaveRepeater(survey, RepeaterQ6, "6");
        SaveSingleSelect(survey, RadioButtonListQ7, "7", TextBoxQ7Detail.Text.Trim());
        SaveSingleSelect(survey, RadioButtonListQI7_1, "I7-1", null);
        if (RadioButtonListQI7_1.SelectedIndex != -1 && RadioButtonListQI7_1.Items[RadioButtonListQI7_1.SelectedIndex].Text.ToUpper() == "YES")
            SaveSingleSelect(survey, RadioButtonListQI7_2, "I7-2", null);
        SaveText(survey, TextBoxQ8, "8");
        SaveText(survey, TextBoxQ9, "9");
        SaveRepeater(survey, RepeaterQ10, "10");
        SaveText(survey, TextBoxQ11, "11");
        SaveText(survey, TextBoxQ12, "12");
    }

    private void SetCheckBoxElement(SURVEY_RESULT result, CheckBoxList checkBoxList, TextBox textBox)
    {
        ListItem cblItem = checkBoxList.Items.FindByValue(result.STD_QUESTION_CHOICE_ID.ToString());
        if (cblItem != null)
        {
            cblItem.Selected = true;
            if (null != textBox && cblItem.Text.ToUpper() == "OTHER")
            {
                textBox.Text = result.RESULT_TEXT;
            }
        }
        else
        {
            //Unable to find a checkbox corresponding to saved survey response
            System.Diagnostics.Debug.WriteLine(string.Format("SetCheckBoxElement-{0}", result.STD_QUESTION_CHOICE_ID));
        }
    }

    private void SetRadioElement(SURVEY_RESULT result, RadioButtonList radioButton, TextBox textBox)
    {
        if (result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
        {
            radioButton.SelectedIndex = result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value;
            if ((textBox != null) && (radioButton.SelectedIndex == radioButton.Items.Count - 1))
            {
                textBox.Text = result.RESULT_TEXT;
            }
        }
        else
        {
            radioButton.SelectedIndex = -1;
        }
    }

    private void SetRepeaterElement(SURVEY_RESULT result, Repeater repeater, string questionNumber)
    {
        int repeaterIndex = GetRepeaterIndexByChoiceID(ref repeater, result.STD_QUESTION_CHOICE_ID.ToString());
        if (repeaterIndex != -1)
        {
            CheckBox cbItem = repeater.Items[repeaterIndex].FindControl(string.Format(CheckBoxIDFormat, questionNumber)) as CheckBox;
            TextBox txtItem = repeater.Items[repeaterIndex].FindControl(string.Format(TextBoxIDFormat, questionNumber)) as TextBox;
            if (cbItem != null && txtItem != null)
            {
                cbItem.Checked = true;
                txtItem.Text = result.RESULT_TEXT;
            }
            else
            {
                //Should never happen
                System.Diagnostics.Debug.WriteLine(string.Format("SetRepeaterElement1-{0}:{1}:{2}", questionNumber, cbItem, txtItem));
            }
        }
        else
        {
            //Unable to find a repeater item corresponding to saved result
            System.Diagnostics.Debug.WriteLine(string.Format("SetRepeaterElement2-repeaterIndex==-1:{0}", questionNumber));
        }
    }

    private void SetTextBoxElement(SURVEY_RESULT survey, TextBox textBox)
    {
        textBox.Text = survey.RESULT_TEXT;
    }

    /// <summary>
    /// Set up survey
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        SetUpSurvey(survey, VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions().Select(item => item.QUESTION_NUMBER).ToList());
    }

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey, List<string> questionList)
    {
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                if (questionList.Contains(sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER))
                {
                    switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                    {
                        case "-1": SetRadioElement(sResult, RadioButtonListNoteType, null); break;
                        case "1": SetTextBoxElement(sResult, TextBoxQ1); break;
                        case "2": SetCheckBoxElement(sResult, CheckBoxListQ2, TextBoxQ2Detail); break;
                        case "2-1": SetTextBoxElement(sResult, TextBoxQ2Comment); break;
                        case "3": SetCheckBoxElement(sResult, CheckBoxListQ3, TextBoxQ3Detail); break;
                        case "3-1": SetTextBoxElement(sResult, TextBoxQ3Comment); break;
                        case "4": SetRepeaterElement(sResult, RepeaterQ4, "4"); break;
                        case "5": SetTextBoxElement(sResult, TextBoxQ5); break;
                        case "6": SetRepeaterElement(sResult, RepeaterQ6, "6"); break;
                        case "7": SetRadioElement(sResult, RadioButtonListQ7, TextBoxQ7Detail); break;
                        case "I7-1": SetRadioElement(sResult, RadioButtonListQI7_1, null); break;
                        case "I7-2": SetRadioElement(sResult, RadioButtonListQI7_2, null); break;
                        case "8": SetTextBoxElement(sResult, TextBoxQ8); break;
                        case "9": SetTextBoxElement(sResult, TextBoxQ9); break;
                        case "10": SetRepeaterElement(sResult, RepeaterQ10, "10"); break;
                        case "11": SetTextBoxElement(sResult, TextBoxQ11); break;
                        case "12": SetTextBoxElement(sResult, TextBoxQ12); break;
                    }
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentCarePlanEntry.aspx", "100030", "SetUpSurvey()");
        }
    }

    private void SetQuestionLabels()
    {
        List<STD_QUESTION> questions = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions();
        NoteTypeLabel.Text = questions.First(q => q.QUESTION_NUMBER == "-1").QUESTION_TEXT + ":";
        Q1Label.Text = "1. " + questions.First(q => q.QUESTION_NUMBER == "1").QUESTION_TEXT;
        Q2Label.Text = "2. " + questions.First(q => q.QUESTION_NUMBER == "2").QUESTION_TEXT;
        Q3Label.Text = "3. " + questions.First(q => q.QUESTION_NUMBER == "3").QUESTION_TEXT;
        Q4Label.Text = "4. " + questions.First(q => q.QUESTION_NUMBER == "4").QUESTION_TEXT;
        Q5Label.Text = "5. " + questions.First(q => q.QUESTION_NUMBER == "5").QUESTION_TEXT;
        Q6Label.Text = "6. " + questions.First(q => q.QUESTION_NUMBER == "6").QUESTION_TEXT;
        Q7Label.Text = "7. " + questions.First(q => q.QUESTION_NUMBER == "7").QUESTION_TEXT;
        QI7_1Label.Text = questions.First(q => q.QUESTION_NUMBER == "I7-1").QUESTION_TEXT;
        QI7_2Label.Text = questions.First(q => q.QUESTION_NUMBER == "I7-2").QUESTION_TEXT;
        Q8Label.Text = "8. " + questions.First(q => q.QUESTION_NUMBER == "8").QUESTION_TEXT;
        Q9Label.Text = "9. " + questions.First(q => q.QUESTION_NUMBER == "9").QUESTION_TEXT;
        Q10Label.Text = "10. " + questions.First(q => q.QUESTION_NUMBER == "10").QUESTION_TEXT;
        Q11Label.Text = "11. " + questions.First(q => q.QUESTION_NUMBER == "11").QUESTION_TEXT;
        Q12Label.Text = "12. " + questions.First(q => q.QUESTION_NUMBER == "12").QUESTION_TEXT;
    }

    private int GetRepeaterIndexByChoiceID(ref Repeater rep, string choiceID)
    {
        int ret = -1;
        string questionID = rep.ID.LastChars(rep.ID.Length - "RepeaterQ".Length);
        string labelName = "LabelQ" + questionID + "ChoiceID";
        for (int i = 0; i < rep.Items.Count; i++)
        {
            Label lblItem = rep.Items[i].FindControl(labelName) as Label;
            if (lblItem != null)
            {
                if (lblItem.Text == choiceID)
                {
                    ret = i;
                    break;
                }
            }
        }
        return ret;
    }

    #endregion

}